/* 
 *  Arnold emulator (c) Copyright, Kevin Thacker 1995-2001
 *  
 *  This file is part of the Arnold emulator source code distribution.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include <stdlib.h>
#include "scrsnap.h"
#include "cpcemu.h"
#include "InterfaceLoadSave.h"
#include "../../cpc/render.h"
#include "../../cpc/bmp.h"
#include "../../cpc/cpcglob.h"

extern int PIXEL_STEP_SHIFT;
extern int ScanLines;
extern int FillScanLines;

//from bmp.c
void BitmapUtil_WritePixelRGB(BMP_HEADER *pBMP, unsigned int X, unsigned int Y, unsigned char r, unsigned char g, unsigned char b);

BOOL Screen_SaveSnapshot(const TCHAR *pFilename, BOOL bAsThumbnail)
{

	int ScreenWidth;
	int ScreenHeight;
	int x,y;
	BMP_HEADER *pBitmap;
	unsigned long BmpFileSize;
	BOOL ret = FALSE;

	int MonitorWidth = X_CRTC_CHAR_WIDTH_DEFAULT;
	int MonitorHeight = Y_CRTC_LINE_HEIGHT_DEFAULT;

	ScreenWidth = (MonitorWidth<<(1+3))>>PIXEL_STEP_SHIFT;
	ScreenHeight = (MonitorHeight);

	/* adjust height for scanlines */
	if (ScanLines)
	{
		ScreenHeight = ScreenHeight<<1;
	}

	if (bAsThumbnail)
	{
		ScreenWidth = ScreenWidth / 5;
		ScreenHeight = ScreenHeight / 5;
	}

	BmpFileSize = BMP_CalculateAllocSize(ScreenWidth, ScreenHeight);
	
	pBitmap = (BMP_HEADER *)malloc(BmpFileSize);

	if (pBitmap)
	{
		BMP_Setup(pBitmap, ScreenWidth, ScreenHeight);

		/* copy data from stored screen buffer to bitmap */
		for (y=0; y<ScreenHeight;y++)
		{
			if ((ScanLines) && (!FillScanLines) && ((y & 1)!=0))
			{
				for (x=0; x<ScreenWidth; x++)
				{
					BitmapUtil_WritePixelRGB(pBitmap, x, y, 0,0,0);
				}
			}
			else
			{
				for (x=0; x<ScreenWidth; x++)
				{
					unsigned char r,g,b;

					/* get pixel from graphics buffer */
					if (bAsThumbnail)
					{
						if ((FillScanLines) || (ScanLines))
						{
							Render_GetPixelRGBAtXY(x*5,((y*5)>>1), &r, &g, &b);
						}
						else
						{
							Render_GetPixelRGBAtXY(x*5,y*5, &r, &g, &b);
						}
					}
					else
					{
						if ((FillScanLines) || (ScanLines))
						{
							Render_GetPixelRGBAtXY(x,(y>>1), &r, &g, &b);
						}
						else
						{
							Render_GetPixelRGBAtXY(x,y, &r, &g, &b);
						}
					}

					/* write to bitmap */
					BitmapUtil_WritePixelRGB(pBitmap, x, y, r,g,b);

				}
			}

		}

		BMP_SetupForSave(pBitmap);

		ret = SaveFile(pFilename, (LPCVOID)pBitmap, BmpFileSize);
		
		free(pBitmap);
	}

	return ret;
}
